/*
 * telemetry.c
 *
 *  Created on: Apr 17, 2015
 *      Author: Jordan
 */

#include "sys_dma.h"
#include "sci.h"
#include "telemetry.h"
#include "guidance.h"
#include "navigation.h"
#include "GPS.h"
#include "ms5611.h"
#include "stdio.h"
#include "string.h"
#include "config.h"
#include "control.h"
#include "math.h"

char tx_buffer[200];
uint8 pending_transfer = 0;
uint8 tele_counter = 0;

g_dmaCTRL dma_sci_config;

void telemetry_init(){
	dma_sci_config.SADD = (uint32)tx_buffer;      	 	/* initial source address             */
	dma_sci_config.DADD = (uint32)&(sciREG->TD);       	/* initial destination address        */
	dma_sci_config.CHCTRL = 0;     						/* next ctrl packet to be trigger + 1 */
	dma_sci_config.FRCNT = 1;      						/* frame count                      */
	dma_sci_config.ELCNT = 1;      						/* element count                      */
	dma_sci_config.ELDOFFSET = 0;  						/* element destination offset         */
	dma_sci_config.ELSOFFSET = 0;  						/* element source offset              */
	dma_sci_config.FRDOFFSET = 0;  						/* frame detination offset            */
	dma_sci_config.FRSOFFSET = 0;  						/* frame source offset                */
	dma_sci_config.PORTASGN =  4;  						/* dma port                           */
	dma_sci_config.RDSIZE = ACCESS_8_BIT;     			/* read element size                  */
	dma_sci_config.WRSIZE = ACCESS_8_BIT;     			/* write element size                 */
	dma_sci_config.TTYPE = FRAME_TRANSFER;     			/* trigger type - frame/block         */
	dma_sci_config.ADDMODERD = ADDR_INC1;  				/* addresssing mode for source        */
	dma_sci_config.ADDMODEWR = ADDR_FIXED;  			/* addresssing mode for destination   */
	dma_sci_config.AUTOINIT = AUTOINIT_OFF;   			/* auto-init mode                     */

	dmaReqAssign(DMA_CH0, 31);
	dmaEnable();
}

void telemetry_step(){
#if TELE_EN == 1
	if(tele_counter == 0 && !dma_busy()){
		float32 roll = get_roll()*180/PI;
		float32 pitch = get_pitch()*180/PI;
		float32 heading = get_yaw()*180/PI;
		float32 lat = get_INS_lat()*1000000;
		float32 lon = get_INS_lon()*1000000;
		float32 alt = -get_NED_z();
		float32 velocity = sqrtf(powf(get_NED_x_dot(),2) + powf(get_NED_y_dot(),2));
		uint32 fix = get_gps_fix()  == 0;
		uint32 n_sats = get_gps_sats();
		float32 hdop = get_gps_hdop()*100;
		uint16 wpt_counter = get_wpt_counter();
		wpt_counter = wpt_counter == N_WAYPOINTS - 1 ? 0 : wpt_counter + 1;
		float32 wpt_distance = get_dist_to_wpt();

		sprintf(tx_buffer,"+++RLL:%5.2f,PCH:%5.2f,COG:%5.2f,ALT:%5.2f,LAT:%6.0f,LON:%6.0f,SOG:%5.2f,FIX:%01d,SAT:%02d,HDO:%3.0f,WPN:%2u,DST:%5.2f***\r\n", roll, pitch, heading, alt, lat, lon, velocity, fix, n_sats, hdop, wpt_counter, wpt_distance);
		dma_send_data(strlen(tx_buffer));
	}
	tele_counter = tele_counter == FS/TELE_RATE-1 ? 0 : tele_counter+1;
#endif
}

uint8 dma_busy(){
	if(pending_transfer && (uint32)((dmaREG->BTCFLAG) & (1 << DMA_CH0)) == 1){
		pending_transfer = 0;
		dmaREG->BTCFLAG = (1 << DMA_CH0);
		sciREG->CLEARINT = (1 << 16);
	}
	return pending_transfer;
}

void dma_send_data(uint32 size){
	dma_sci_config.FRCNT = size;
	dmaSetCtrlPacket(DMA_CH0, dma_sci_config);
	dmaSetChEnable(DMA_CH0, DMA_HW);
	sciREG->SETINT = (1 << 16);
	pending_transfer = 1;
}
